/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.resources.bbmodel.BBModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class BBModelLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    protected static final int PATH_SUFFIX_LENGTH = 8;
    protected static final int PATH_PREFIX_LENGTH = 8;
    public static final Map<ResourceLocation, BBModel> MODELS = new HashMap<ResourceLocation, BBModel>();
    private final Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : resourceManager.m_214159_("objects", n -> n.m_135815_().endsWith(".bbmodel")).entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            String name = location.m_135815_();
            ResourceLocation id = new ResourceLocation(location.m_135827_(), name.substring(8, name.length() - 8));
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                if (jsonElement != null) {
                    map.put(id, jsonElement);
                    continue;
                }
                Main.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)location);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Main.LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)location, (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        MODELS.clear();
        jsonMap.forEach((identifier, jsonElement) -> MODELS.put((ResourceLocation)identifier, new BBModel(jsonElement.getAsJsonObject(), (ResourceLocation)identifier)));
        System.out.printf("Loaded %d BBModels\n", MODELS.size());
    }
}

